(
    -- CompositeTexturemap Texture: FULL IMPLEMENTATION

    struct AMGData 
    (
        fn GetUUID mtl context =
        (
            "5d210056-f52c-4c17-8cba-0fef8f265f26"
        ),

        fn GetMaps mtl context =
        (
            local res = #()	
            
            local layer = mtl.mapList.count - (context / 256)
            local newContext = mod context 256

            if (mtl.mapList[layer] != undefined and mtl.mapEnabled[layer]) do
            (
				if (newContext == 1) then
				(
					-- Bump mode
					append res #("fg",           mtl.mapList[layer],  "normalPerturb", newContext) 
				)
				else
				(
					-- Regular mode, also attach alpha
					append res #("fg",           mtl.mapList[layer],  "result", newContext) 
					append res #("alpha",        mtl.mapList[layer],  "alpha",  newContext) 
				)
            )
            if (mtl.mask[layer] != undefined and mtl.maskEnabled[layer]) do
            (
                append res #("mask",           mtl.mask[layer],   "resultFloat", newContext) 
            )

            -- Recurseively append yourself
            if (layer > 1) do
            (
                append res #("bg",           mtl, "result", context + 256) 
				append res #("bgalpha",      mtl, "alpha", context + 256) 
            )

            res
        ),

        fn GetParams mtl context = 
        (
            local res = #()	

            local layer = mtl.mapList.count - (context / 256)

            if mtl.mapList[layer] != undefined and mtl.mapEnabled[layer] then
            (
                append res #( "weight",   (mtl.Opacity[layer] / 100.0))  
            )
            else
            (
                append res #( "weight",   0.0)  
            )

            append res #( "mode",	  mtl.blendMode[layer])  
            append res #( "mask",	  1.0)            -- Default
            append res #( "bg",	      (color 0 0 0))  -- Default
            append res #( "fg",	      (color 0 0 0))  -- Default

            res
        )
    )

    AMGData()
)